<?php

/**
 * Plugin Name: Nomad Blocks
 * Description: Nomad専用ブロックエディタープラグイン
 * Author: Nomad & RETVAL
 * Version: 1.0.5
 */

if (!defined('ABSPATH')) {
	exit;
}

define('NMDB_VERSION', '1.0.5');
define('NMDB_PLUGIN_DIR_URL', plugin_dir_url(__FILE__));
define('NMDB_PLUGIN_DIR', dirname(__FILE__));

define('NMDB_BLOCKS_HOME_URL', home_url());
define('NMDB_TEXT_DOMAIN', 'nmd-blocks');

load_plugin_textdomain(
	NMDB_TEXT_DOMAIN,
	false,
	basename(dirname(__FILE__)) . '/languages'
);

require(NMDB_PLUGIN_DIR . '/lib/func/func-image.php');
require(NMDB_PLUGIN_DIR . '/lib/func/func-excerpt.php');
require(NMDB_PLUGIN_DIR . '/lib/func/func-text.php');
require(NMDB_PLUGIN_DIR . '/lib/func/func-post-data.php');
require(NMDB_PLUGIN_DIR . '/lib/func/func-get-theme.php');
require(NMDB_PLUGIN_DIR . '/lib/func/func-register-block-type.php');

require(NMDB_PLUGIN_DIR . '/lib/colors.php');

require(NMDB_PLUGIN_DIR . '/lib/settings/filters.php');
require(NMDB_PLUGIN_DIR . '/lib/settings/actions.php');
require(NMDB_PLUGIN_DIR . '/lib/settings/speech-bubble.php');

require(NMDB_PLUGIN_DIR . '/lib/render-callback/callback.php');

function nmdb_blocks_register()
{

	wp_register_script(
		'nmd-blocks-editor-script',
		plugins_url('dist/editor.js', __FILE__),
		array('wp-blocks', 'wp-i18n', 'wp-element', 'wp-block-editor', 'wp-components', 'wp-element', 'lodash', 'wp-blob', 'wp-data', 'wp-server-side-render'),
		NMDB_VERSION
	);

	wp_register_script(
		'nmd-blocks-script',
		plugins_url('dist/script.js', __FILE__),
		array('jquery'),
		NMDB_VERSION,
		true
	);

	wp_register_style(
		'nmd-blocks-editor-style',
		plugins_url('dist/editor.css', __FILE__),
		array('wp-edit-blocks'),
		NMDB_VERSION
	);

	wp_register_style(
		'nmd-blocks-style',
		plugins_url('dist/style.css', __FILE__),
		array(),
		NMDB_VERSION
	);

	// 管理者のデータを取得
	$args = array(
		'orderby'	=> 'ID',
		'role'		=> 'Administrator',
	);
	$users_data = get_users($args);

	// 管理画面のURLを取得
	$admin_url = admin_url();

	$add_value = array(
		'path'		=> NMDB_PLUGIN_DIR_URL,
		'homeUrl'	=> home_url('/'),
		'users'		=> $users_data,
		'adminUrl'	=> $admin_url,
	);

	wp_localize_script('nmd-blocks-editor-script', 'nmdbJsValue', $add_value);
	wp_localize_script('nmd-blocks-script', 'nmdbJsValue', $add_value);

	/**
     * 吹き出し管理の設定を取得
     */
    $speaker_sets = array();
    $args = array(
        'post_type' => 'speaker'
    );
    $posts = get_posts( $args );

    if( $posts ) {
        foreach( $posts as $post ) {
            $id = $post->ID;
            $speaker_title = get_the_title( $id );
            $speaker_image = get_post_meta( $id, 'speaker_image', true );
            $speaker_name = get_post_meta( $id, 'speaker_name', true );
    
            $speaker_sets[$id] = array(
                'title' => $speaker_title,
                'image' => $speaker_image,
                'name' => $speaker_name,
            );
            
        }
    }
    wp_reset_postdata();

    $vars = array(
        'data' => $speaker_sets,
    );

	wp_localize_script( 'nmd-blocks-editor-script', 'speakerJsValue', $vars );

	nmdb_blocks_register_block_type('original-accordion-parent');
	nmdb_blocks_register_block_type('original-accordion');
	nmdb_blocks_register_block_type('original-box');
	nmdb_blocks_register_block_type('original-box-title');
	nmdb_blocks_register_block_type('original-button');
	nmdb_blocks_register_block_type('original-card');
	nmdb_blocks_register_block_type('original-cvbox');
	nmdb_blocks_register_block_type('original-heading');
	nmdb_blocks_register_block_type('original-list');
	nmdb_blocks_register_block_type('original-qa');
	nmdb_blocks_register_block_type('original-speechbubble');
	nmdb_blocks_register_block_type('original-access-ranking');
	nmdb_blocks_register_block_type('original-category-image-list');
	nmdb_blocks_register_block_type('original-category-image');
	nmdb_blocks_register_block_type('original-cta');
	nmdb_blocks_register_block_type('original-explanation');
	nmdb_blocks_register_block_type('original-latest');
	nmdb_blocks_register_block_type('original-likefb');
	nmdb_blocks_register_block_type('original-profile');
	nmdb_blocks_register_block_type('original-ranking-list');
	nmdb_blocks_register_block_type('original-ranking');
	nmdb_blocks_register_block_type('original-recommend-list');
	nmdb_blocks_register_block_type('original-recommend');
	nmdb_blocks_register_block_type('original-related');

	/**
	 * ウィジェットにクラス名を追加
	 */
	function nmdb_widget_add_classname($classname, $block_name) {

		switch ( $block_name ) {
			case 'nmd-blocks/original-related':
				$classname .= ' widget_nmd_related_post';
				break;

			case 'nmd-blocks/original-likefb' :
				$classname .= ' widget_nmd_like_fb';
				break;

			case 'nmd-blocks/original-ranking-list':
				$classname .= ' widget_nmd_ranking';
				break;

			case 'nmd-blocks/original-profile':
				$classname .= ' widget_nmd_profile';
				break;
		}
		
		return $classname;
	}
	add_filter( 'widget_block_dynamic_classname', 'nmdb_widget_add_classname', 10, 2 );
}
add_action('init', 'nmdb_blocks_register');


/**
 * アップデート
 */
require( NMDB_PLUGIN_DIR . '/update-checker/plugin-update-checker.php' );

try {
	$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
		'https://wp.nomad.inc/plugin-update-file/nomad-plugin.json',
		__FILE__,
		'nmd-blocks'
	);
} catch (Exception $e) {

}
