<?php
/**
 * 吹き出し管理設定
 */
if ( !defined( 'ABSPATH' ) ) {
  exit;
}

// 吹き出し管理の追加
if( !function_exists( 'nmdb_post_type_speaker' ) ) {
	function nmdb_post_type_speaker() {
		register_post_type( "speaker",
			array(
				"labels" => array(
					"name"          => __("吹き出し管理", 'nmd-blocks'),
					"singular_name" => __("吹き出し管理", 'nmd-blocks'),
					'edit_item'     => __("吹き出し設定の編集", 'nmd-blocks'),
					'add_new_item'  => __("新規の吹き出し設定", 'nmd-blocks'),
					'all_items'     => __("吹き出し設定一覧", 'nmd-blocks'),
				),
                    "public" => false,
                    'show_ui' => true,
                    "menu_position" =>8,
                    "menu_icon" => "dashicons-format-chat",
                    "exclude_from_search" => true,
                    'supports' => array(
                    'title',
				),
			)
		);
	}
	add_action( "init", "nmdb_post_type_speaker" );
}

if( !function_exists( 'nmdb_add_script_thickbox' ) ) {
	function nmdb_add_script_thickbox() { 
		wp_enqueue_media();
		wp_enqueue_style( 'thickbox' );
	}
	add_action('admin_print_scripts-post.php', 'nmdb_add_script_thickbox');
	add_action('admin_print_scripts-post-new.php', 'nmdb_add_script_thickbox');
}

/**
 * ここからカスタムフィールドの設定
 */
if( !function_exists( 'nmdb_add_speaker_fields_meta_box' ) ) {
	function nmdb_add_speaker_fields_meta_box() {
		add_meta_box(
			'image_upload_meta_box', // $id
			__("吹き出しの設定", 'nmd-blocks'), // $title
			'nmdb_show_speaker_fields_meta_box', // $callback
			'speaker', // $screen
			'normal', // $context
			'high' // $priority
		);
	}
	add_action( 'add_meta_boxes', 'nmdb_add_speaker_fields_meta_box' );
}
if( !function_exists( 'nmdb_show_speaker_fields_meta_box' ) ) {
	function nmdb_show_speaker_fields_meta_box() {
		global $post;
		$speaker_image = get_post_meta( $post->ID, 'speaker_image', true );
		$speaker_name = get_post_meta( $post->ID, 'speaker_name', true );
		?>

		<input type="hidden" name="_wp_nonce_nmdb_speaker" value="<?php echo wp_create_nonce( basename(__FILE__) ); ?>">
		<p>
			<label for="speaker_name"><?php _e("名前", 'nmd-blocks'); ?></label><br>
			<input type="text" name="speaker_name" id="speaker_name" value="<?php echo $speaker_name; ?>">
		</p>
		<p>
			<label for="speaker_image"><?php _e("吹き出しのアイコン", 'nmd-blocks'); ?></label><br>
			<input type="text" name="speaker_image" id="speaker_image" class="meta-image regular-text" value="<?php echo $speaker_image; ?>">
			<input type="button" class="button image-upload" value="メディアをアップロード">
		</p>
		<div class="image-preview"><img src="<?php echo $speaker_image; ?>" alt="" style="max-width: 150px;"></div>

		<?php
	}
}
if( !function_exists( 'nmdb_org_caution_title_head' ) ) {
	function nmdb_org_caution_title_head( $post ){
		if( $post->post_type == "speaker" ){
		echo '<p style="font-size: 1rem;margin: 20px 0 0;">他の吹き出しと被らないタイトルをつけてください。タイトルは記事内に表示されません。</p>';
		}
	}
	add_action( 'edit_form_top', 'nmdb_org_caution_title_head' );
}
if( !function_exists( 'nmdb_save_speaker_fields_meta' ) ) {
	function nmdb_save_speaker_fields_meta( $post_id ) {
		// verify nonce
		if ( !isset( $_POST['_wp_nonce_nmdb_speaker'] ) || !wp_verify_nonce( $_POST['_wp_nonce_nmdb_speaker'], basename(__FILE__) ) ) {
			return $post_id;
		}
		// check autosave
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}
		// check permissions
		if ( 'page' === $_POST['post_type'] ) {
			if ( !current_user_can( 'edit_page', $post_id ) ) {
				return $post_id;
			} elseif ( !current_user_can( 'edit_post', $post_id ) ) {
				return $post_id;
			}
		}
		nmdb_check_speaker_meta_value( $post_id, 'speaker_image' );
		nmdb_check_speaker_meta_value( $post_id, 'speaker_name' );
	}
	add_action( 'save_post', 'nmdb_save_speaker_fields_meta' );
}
if( !function_exists( 'nmdb_check_speaker_meta_value' ) ) {
	function nmdb_check_speaker_meta_value( $post_id, $meta_id ) {
		$old = get_post_meta( $post_id, $meta_id, true );
		$new = $_POST[$meta_id];

		if ( $new && $new !== $old ) {
			update_post_meta( $post_id, $meta_id, $new );
		} elseif ( '' === $new && $old ) {
			delete_post_meta( $post_id, $meta_id, $old );
		}
	}
}
