<?php

function nmdb_add_inline_style()
{
	$is_nomad = nmdb_is_theme_nomad();
	$main_color = $is_nomad ? get_option('nmd_main_color', '#29CAD8') : '#29CAD8';
?>
	<style>
		:root {
			--nmdb-theme-main-color: <?php echo $main_color; ?>;
		}
	</style>
<?php
}
add_action('wp_head', 'nmdb_add_inline_style');
add_action("admin_head", "nmdb_add_inline_style");

if (!function_exists('nmdb_edit_page_script')) {
	function nmdb_edit_page_script()
	{
		if (is_admin()) {

			wp_enqueue_script(
				'nmdb_edit_page_script',
				plugins_url('dist/classicEditor.js', __FILE__),
				array('jquery'),
				NMDB_VERSION,
				true
			);
		}
	}
	add_action("admin_head-post-new.php", "nmdb_edit_page_script");
	add_action("admin_head-post.php", "nmdb_edit_page_script");
}
?>