<?php

function nmdb_get_related_post($attributes)
{
    if ( ! is_single() ) return '';

    $selected_style = ! empty( $attributes["className"] ) ? $attributes["className"] : 'is-style-default';

    $classname = "wp-block-nmd-blocks-original-related" . ' ' . $selected_style;

    $num = ( ! empty( $attributes['num'] ) && is_numeric( $attributes['num' ]) )
        ? $attributes['num']
        : 5;

    if (is_string($num)) $num = intval($num);

    global $post;

    if (empty($post)) return '';
    $current_post_id = $post->ID;
    $categories = get_the_category($current_post_id);

    $category_id = array();
    foreach ($categories as $category) {
        array_push($category_id, $category->cat_ID);
    }

    $args = array(
        'post__not_in'    => array($current_post_id),
        'posts_per_page'  => $num,
        'category__in'    => $category_id,
        'orderby'         => 'rand',
    );

    $wp_query = new WP_Query($args);

    ob_start();
?>
    <div class="<?php echo $classname; ?>">
        <?php if( ! empty( $attributes['title'] ) ) : ?>
            <h2 class="widget__title">
                <span class="widget__title-inner">
                    <?php echo $attributes['title']; ?>
                </span>
            </h2>
        <?php endif; ?>
        <?php if ($wp_query->have_posts()) : ?>
            <div class="nmdb-related-article">
                <?php while ($wp_query->have_posts()) : $wp_query->the_post(); ?>
                    <?php
                    $post_id = get_the_ID();
                    $title = get_the_title();
                    $title = nmdb_mb_substr_text($title, 36);
                    $thumb_url = $selected_style === 'is-style-default' ? nmdb_get_thumbnail_url($post_id, "medium") : null;
                    $categories = get_the_category($post_id);
                    $category = $categories ? $categories[0] : false;
                    $datetime = get_the_date('Y-m-d', $post_id);
                    $time = get_the_date('Y.m.d', $post_id);
                    ?>
                    <a href="<?php echo get_the_permalink(); ?>" class="nmdb-related-article__item">
                        <article class="nmdb-related-article-card">
                            <?php if ( $thumb_url ): ?>
                                <figure class="nmdb-related-article-card__thumb">
                                    <img src="<?php echo $thumb_url; ?>" alt="<?php echo $title; ?>" loading="lazy" />
                                </figure>
                            <?php endif; ?>
                            <div class="nmdb-related-article-card__content">
                                <?php if ($category) : ?>
                                    <p class="nmdb-related-article-card__cat">
                                        <?php echo $category->name; ?>
                                    </p>
                                <?php endif; ?>
                                <h2 class="nmdb-related-article-card__title">
                                    <?php echo $title; ?>
                                </h2>
                                <p class="nmdb-related-article-card__date">
                                    <time datetime="<?php echo $datetime; ?>"><?php echo $time; ?></time>
                                </p>
                            </div>
                        </article>
                    </a>
                <?php endwhile; ?>
            </div>
        <?php else : ?>
            <p class="nmdb-no-entry">関連記事はありません。</p>
        <?php endif; ?>
    </div>
<?php
    $content = ob_get_clean();

    wp_reset_postdata();


    return $content;
}

function nmdb_register_block_original_related() {
	register_block_type('nmd-blocks/original-related', array(
		'editor_script'	=> 'nmd-blocks-editor-script',
		'editor_style'	=> 'nmd-blocks-editor-style',
		'script'		=> 'nmd-blocks-script',
		'style'			=> 'nmd-blocks-style',
		'attributes' 	=> array(
			'title' => array(
				'type' => 'html',
                'default' => __('関連記事', NMDB_TEXT_DOMAIN),
			),
			'num' => array(
				'type' => 'string',
			),
		),
		'render_callback'	=> 'nmdb_get_related_post',
	));
}
add_action('init', 'nmdb_register_block_original_related');