<?php

function nmdb_get_recommend_post($attributes)
{

	if (empty($attributes['postId'])) return '';

	$post_id   = $attributes['postId'];
	$post_data = get_post($post_id);

	if (empty($post_data)) return '<p class="nmdb-card-link__notfound">記事が見つかりませんでした。</p>';

	$selected_style = !empty($attributes["className"]) ? $attributes["className"] : 'is-style-default';
	$class_name = 'nmdb-recommend-post ' . $selected_style;
	$title     = get_the_title($post_id);
	$title     = nmdb_mb_substr_text($title, 36);
	$url       = get_permalink($post_id);
	$thumb_url = nmdb_get_thumbnail_url($post_id, "medium");
	$categories = get_the_category($post_id);
	$category = $categories ? $categories[0] : false;
	$datetime = get_the_date('Y-m-d', $post_id);
	$time = get_the_date('Y.m.d', $post_id);

	ob_start();
?>
	<div class="<?php echo $class_name; ?>">
		<a href="<?php echo get_the_permalink(); ?>" class="nmdb-recommend-post__item">
			<article class="nmdb-recommend-post-card">
				<?php if ($selected_style === 'is-style-default') : ?>
					<figure class="nmdb-recommend-post-card__thumb">
						<img src="<?php echo $thumb_url; ?>" alt="<?php echo $title; ?>" loading="lazy" />
					</figure>
				<?php endif; ?>
				<div class="nmdb-recommend-post-card__content">
					<?php if ($category) : ?>
						<p class="nmdb-recommend-post-card__cat">
							<?php echo $category->name; ?>
						</p>
					<?php endif; ?>
					<h2 class="nmdb-recommend-post-card__title">
						<?php echo $title; ?>
					</h2>
					<p class="nmdb-recommend-post-card__date">
						<time datetime="<?php echo $datetime; ?>"><?php echo $time; ?></time>
					</p>
				</div>
			</article>
		</a>
	</div>
<?php
	$content = ob_get_clean();

	wp_reset_postdata();


	return $content;
}

function nmdb_register_block_original_recommend_post() {
	register_block_type('nmd-blocks/original-recommend', array(
		'editor_script'		=> 'nmd-blocks-editor-script',
		'editor_style'		=> 'nmd-blocks-editor-style',
		'script'			=> 'nmd-blocks-script',
		'style'				=> 'nmd-blocks-style',
		'attributes' 		=> array(
			'postId' => array(
				'type' => 'string',
			),
		),
		'render_callback'	=> 'nmdb_get_recommend_post',
	));
}
add_action('init', 'nmdb_register_block_original_recommend_post');
