<?php

function nmdb_get_profile_callback($attributes)
{
	// 管理者のデータを取得
	$args = array(
		'orderby'	=> 'ID',
		'role'		=> 'Administrator',
	);
	$users_data = get_users($args);

	$user_id = !empty($attributes["user_id"]) ? $attributes["user_id"] : $users_data[0]->ID;
	
	// image
	$src = !empty($attributes["src"]) ? $attributes["src"] : null;

	// button
	$url		= ! empty($attributes["url"]) ? $attributes["url"] : null;
	$text		= ! empty($attributes["text"]) ? $attributes["text"] : null;

	$btn_color	= ! empty($attributes["btnColor"]) ? $attributes["btnColor"] : '#29CAD8';
	$target		= '';
	
	if ( ! empty( $attributes["target"] ) && $attributes["target"] === '_blank' ) {
		$target = ' target="_blank"';
	}

	$rel = $target === '_blank' ? ' rel="noopener noreferrer"' : '';

	$user_data = get_userdata($user_id);
	$user_name = $user_data->display_name;

	$avatar_html = get_avatar($user_id, 96, '', $user_name);

	$allowed_tags = wp_kses_allowed_html( 'post' );
    $user_description = wp_kses( get_user_meta( $user_id, 'description', true ), $allowed_tags );
    $user_description = nl2br( $user_description );

	// sns
	$fb_url		= esc_url( get_user_meta( $user_id, 'facebook', true ) );
	$tw_url		= esc_url( get_user_meta( $user_id, 'twitter', true ) );
    $insta_url	= esc_url( get_user_meta( $user_id, 'instagram', true ) );
    $line_url	= esc_url( get_user_meta( $user_id, 'line', true ) );
    $yt_url		= esc_url( get_user_meta( $user_id, 'youtube', true ) );
	
	ob_start();
?>
	<div class="wp-block-nmd-blocks-original-profile">
		<div class="profile">
			<div class="profile-top-img">
				<?php if ($src) : ?>
					<img src="<?php echo $src; ?>" alt="プロフィール画像" loading="lazy" />
				<?php endif; ?>
			</div>
			<div class="profile-avatar">
				<?php echo $avatar_html; ?>
			</div>
			<div class="profile-content">
				<p class="profile-content__name"><?php echo $user_name; ?></p>
				<p class="profile-content__text">
					<?php echo $user_description; ?>
				</p>
				<?php if ( $url && $text ) : ?>
					<a href="<?php echo $url; ?>" class="profileBtn" style="background-color: <?php echo $btn_color; ?>"<?php echo $target; ?><?php echo $rel; ?>>
						<?php echo $text; ?>
					</a>
				<?php endif; ?>
				<div class="profile-flex">
					<?php if ($fb_url) : ?>
						<a href="<?php echo $fb_url; ?>" class="profile-flex__icon">
							<img src="<?php echo NMDB_PLUGIN_DIR_URL . 'dist/images/icon/share-gray/fb.svg' ?>" alt="" loading="lazy" />
						</a>
					<?php endif; ?>
					<?php if ($tw_url) : ?>
						<a href="<?php echo $tw_url; ?>" class="profile-flex__icon">
							<img src="<?php echo NMDB_PLUGIN_DIR_URL . 'dist/images/icon/share-gray/tw.svg' ?>" alt="" loading="lazy" />
						</a>
					<?php endif; ?>
					<?php if ($insta_url) : ?>
						<a href="<?php echo $insta_url; ?>" class="profile-flex__icon">
							<img src="<?php echo NMDB_PLUGIN_DIR_URL . 'dist/images/icon/share-gray/ig.svg' ?>" alt="" loading="lazy" />
						</a>
					<?php endif; ?>
					<?php if ($line_url) : ?>
						<a href="<?php echo $line_url; ?>" class="profile-flex__icon">
							<img src="<?php echo NMDB_PLUGIN_DIR_URL . 'dist/images/icon/share-gray/line.svg' ?>" alt="" loading="lazy" />
						</a>
					<?php endif; ?>
					<?php if ($yt_url) : ?>
						<a href="<?php echo $yt_url; ?>" class="profile-flex__icon">
							<img src="<?php echo NMDB_PLUGIN_DIR_URL . 'dist/images/icon/share-gray/yt.svg' ?>" alt="" loading="lazy" />
						</a>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
<?php
	$content = ob_get_contents();

	ob_end_clean();

	return $content;
}

function nmdb_register_block_original_profile() {
	register_block_type('nmd-blocks/original-profile', array(
		'editor_script'	=> 'nmd-blocks-editor-script',
		'editor_style'	=> 'nmd-blocks-editor-style',
		'script'		=> 'nmd-blocks-script',
		'style'			=> 'nmd-blocks-style',
		'attributes' 	=> array(
			'text' => array(
				'type' => 'string',
			),
			'url' => array(
				'type' => 'string',
			),
			'user_id' => array(
				'type' => 'number',
			),
			'src' => array(
				'type' => 'string',
			),
			'id' => array(
				'type' => 'number',
			),
			'btnColor' => array(
				'type' => 'string',
				'default' => '#29CAD8',
			),
			'target' => array(
				'type' => 'string',
				'default' => false,
			)
		),
		'render_callback' => 'nmdb_get_profile_callback',
	));
}
add_action('init', 'nmdb_register_block_original_profile');