<?php

function nmdb_get_latest_post($attributes)
{

    $selected_style = ! empty( $attributes["className"] ) ? $attributes["className"] : 'is-style-default';

    $classname = "wp-block-nmd-blocks-original-latest" . ' ' . $selected_style;

    $num = ( ! empty( $attributes['num'] ) && is_numeric( $attributes['num' ]) )
        ? $attributes['num']
        : 5;

    if (is_string($num)) $num = intval($num);

    $sticky = get_option('sticky_posts'); //先頭固定の記事

    if ( !empty($sticky) ) $num -= count($sticky);

    if ( $num <= 0) $num = 1;

    $args = array(
        'posts_per_page'  => $num,
    );

    $wp_query = new WP_Query($args);

    ob_start();
?>
    <div class="<?php echo $classname; ?>">
        <?php if( ! empty( $attributes['title'] ) ) : ?>
            <h2 class="widget__title">
                <span class="widget__title-inner">
                    <?php echo $attributes['title']; ?>
                </span>
            </h2>
        <?php endif; ?>
        <?php if ($wp_query->have_posts()) : ?>
            <div class="nmdb-latest-article">
                <?php while ($wp_query->have_posts()) : $wp_query->the_post(); ?>
                    <?php
                    $post_id = get_the_ID();
                    $title = get_the_title();
                    $title = nmdb_mb_substr_text($title, 36);
                    $thumb_url = $selected_style === 'is-style-default' ? nmdb_get_thumbnail_url($post_id, "medium_large") : null;
                    $categories = get_the_category($post_id);
                    $category = $categories ? $categories[0] : false;
                    $datetime = get_the_date('Y-m-d', $post_id);
                    $time = get_the_date('Y.m.d', $post_id);
                    ?>
                    <a href="<?php echo get_the_permalink(); ?>" class="nmdb-latest-article__item">
                        <article class="nmdb-latest-article-card">
                            <?php if ( $thumb_url ): ?>
                                <figure class="nmdb-latest-article-card__thumb">
                                    <img src="<?php echo $thumb_url; ?>" alt="<?php echo $title; ?>" loading="lazy" />
                                </figure>
                            <?php endif; ?>
                            <div class="nmdb-latest-article-card__content">
                                <?php if ($category) : ?>
                                    <p class="nmdb-latest-article-card__cat">
                                        <?php echo $category->name; ?>
                                    </p>
                                <?php endif; ?>
                                <h2 class="nmdb-latest-article-card__title">
                                    <?php echo $title; ?>
                                </h2>
                                <p class="nmdb-latest-article-card__date">
                                    <time datetime="<?php echo $datetime; ?>"><?php echo $time; ?></time>
                                </p>
                            </div>
                        </article>
                    </a>
                <?php endwhile; ?>
            </div>
        <?php else : ?>
            <p class="nmdb-no-entry">新着記事はありません。</p>
        <?php endif; ?>
    </div>
<?php
    $content = ob_get_clean();

    wp_reset_postdata();

    return $content;
}

function nmdb_register_block_original_latest() {
	register_block_type('nmd-blocks/original-latest', array(
		'editor_script'	=> 'nmd-blocks-editor-script',
		'editor_style'	=> 'nmd-blocks-editor-style',
		'script'		=> 'nmd-blocks-script',
		'style'			=> 'nmd-blocks-style',
		'attributes' 	=> array(
			'title' => array(
				'type' => 'string',
                'default' => __('新着記事', NMDB_TEXT_DOMAIN),
			),
			'num' => array(
				'type' => 'string',
			),
		),
		'render_callback'	=> 'nmdb_get_latest_post',
	));
}
add_action('init', 'nmdb_register_block_original_latest');