<?php

/**
 * 内部リンク用ブログカード
 * @since 1.0.0
 * @return string
 */
function nmdb_get_category_image_callback($attributes)
{
	if ( empty($attributes['catId']) || ! is_numeric($attributes['catId'])) return '';

	$cat_id = $attributes['catId'];
	$category = get_category($cat_id);
	$cat_link = get_category_link($cat_id);

	if ( ! empty( $attributes['height'] ) && is_numeric( $attributes['height'] ) ) {
		$height = $attributes['height'] . 'px';
	} else {
		$height = '50px';
	}

	$cat_img = !empty( $attributes['url'] ) ? $attributes['url'] : '';

	ob_start();
?>
	<a class="nmdb-category-image" href="<?php echo $cat_link; ?>">
		<figure class="nmdb-category-image__bg" style="height: <?php echo $height; ?>;">
			<?php if ($cat_img) : ?>
				<img src="<?php echo $cat_img; ?>" alt="<?php echo $category->name; ?>" loading="lazy" />
			<?php endif; ?>
		</figure>
		<div class="nmdb-category-image__body">
			<p class="nmdb-category-image__name">
				<?php echo $category->name; ?>
			</p>
		</div>
	</a>
<?php

	$content = ob_get_clean();

	return $content;
}

function nmdb_register_block_original_category_image()
{
	register_block_type('nmd-blocks/original-category-image', array(
		'editor_script'	=> 'nmd-blocks-editor-script',
		'editor_style'	=> 'nmd-blocks-editor-style',
		'script'		=> 'nmd-blocks-script',
		'style'			=> 'nmd-blocks-style',
		'attributes' 	=> array(
			'catId' => array(
				'type' => 'string',
			),
			'url' => array(
				'type' => 'string',
			),
			'height' => array(
				'type' => 'number',
			),
		),
		'render_callback'	=> 'nmdb_get_category_image_callback',
	));
}
add_action('init', 'nmdb_register_block_original_category_image');
