<?php

/**
 * 内部リンク用ブログカード
 * @since 1.0.0
 * @return string
 */
function nmdb_get_post_link_callback($attributes) {

	if (empty($attributes['postId'])) return '';

	$post_id   = $attributes['postId'];
	$post_data = get_post($post_id);

	if (empty($post_data)) return '<p class="nmdb-card-link__notfound">記事が見つかりませんでした。</p>';

	$selected_style = !empty($attributes["className"]) ? $attributes["className"] : 'is-style-default';
	$class_name = 'nmdb-card-link ' . $selected_style;
	$title     = get_the_title($post_id);
	$title     = nmdb_mb_substr_text($title, 30);
	$url       = get_permalink($post_id);
	$excerpt_length_pc = 78;
	$excerpt_length_sp = 30;

	switch ($selected_style) {
		case 'is-style-big':
			$excerpt_length_pc = 24;
			$excerpt_length_sp = 24;
			break;
		
		default:
			# code...
			break;
	}

	$excerpt   = nmdb_get_excerpt($excerpt_length_pc, $post_id, false);
	$excerpt_sp   = nmdb_get_excerpt($excerpt_length_sp, $post_id, false);
	$thumb_size = $selected_style === 'is-style-default' ? 'thumbnail' : 'large';
	$thumb_src = nmdb_get_thumbnail_url($post_id, $thumb_size);

	ob_start();
	?>
	<a class="<?php echo $class_name; ?>" href="<?php echo $url; ?>">
		<figure class="nmdb-card-link__thumb">
			<img src="<?php echo $thumb_src; ?>" alt="<?php echo $title; ?>" loading="lazy" />
		</figure>
		<div class="nmdb-card-link__body">
			<p class="nmdb-card-link__ttl"><?php echo $title; ?></p>
			<p class="nmdb-card-link__excerpt"><?php echo $excerpt; ?></p>
			<p class="nmdb-card-link__excerpt nmdb-card-link__excerpt--sp"><?php echo $excerpt_sp; ?></p>
		</div>
	</a>
	<?php

	$content = ob_get_clean();

	return $content;
}

function nmdb_register_block_original_card_link() {
	register_block_type('nmd-blocks/original-card', array(
		'editor_script'	=> 'nmd-blocks-editor-script',
		'editor_style'	=> 'nmd-blocks-editor-style',
		'script'		=> 'nmd-blocks-script',
		'style'			=> 'nmd-blocks-style',
		'attributes' 	=> array(
			'postId' => array(
				'type' => 'string',
			),
		),
		'render_callback'	=> 'nmdb_get_post_link_callback',
	));
}
add_action('init', 'nmdb_register_block_original_card_link');