<?php

function nmdb_get_access_ranking($attributes)
{

	if ( empty($attributes['num'] ) || !is_numeric( $attributes['num'] ) ) {
		$num = 5;
	} else {
		$num = $attributes['num'];
	}
	
	if( isset($attributes['displayNum'] ) ) {
		$display_num = $attributes['displayNum'];
	} else {
		$display_num = true;
	}


	$args = array(
		'posts_per_page' => $num,
		'offset' => 0,
		'order' => 'DESC',
		'orderby' => 'meta_value_num',
		'meta_key'  => 'nmd_post_views_count',
		'post__not_in' => get_option('sticky_posts'),
	);
	$the_query = new WP_Query($args);

	ob_start();
?>

	<div class="wp-block-nmd-blocks-original-access-ranking">
		<?php if ( ! empty( $attributes['title'] ) ) : ?>
			<h2 class="widget__title">
				<span class="widget__title-inner">
					<?php echo $attributes['title']; ?>
				</span>
			</h2>
		<?php endif; ?>
		<?php if ($the_query->have_posts() || nmdb_is_theme_nomad()) : ?>
			<div class="access-ranking">
				<?php while ($the_query->have_posts()) : $the_query->the_post(); ?>
					<?php
					$id = get_the_ID();
					$title = get_the_title();
					$title = nmdb_mb_substr_text($title, 50);
					$post_url = get_the_permalink();
					$thumb_url = nmdb_get_thumbnail_url($id, 'medium_large');
					$view_num = nmdb_get_post_views($id);
					?>
					<a href="<?php echo $post_url; ?>" class="access-ranking__item">
						<article class="access-ranking__card">
							<div class="access-ranking__badge">
								<svg xmlns="http://www.w3.org/2000/svg" width="27.377" height="32" viewBox="0 0 27.377 32">
									<g transform="translate(27.377) rotate(90)" fill="#29cad8" class="ranking-svg">
										<path d="M 23.42616653442383 26.37725448608398 L 8.573833465576172 26.37725448608398 L 1.158260107040405 13.68862438201904 L 8.573833465576172 1.000004410743713 L 23.42616653442383 1.000004410743713 L 30.84173965454102 13.68862438201904 L 23.42616653442383 26.37725448608398 Z" stroke="none"/>
										<path d="M 9.147661209106445 1.999994277954102 L 2.31651496887207 13.68862438201904 L 9.147661209106445 25.37724494934082 L 22.85234069824219 25.37724494934082 L 29.68348503112793 13.68862438201904 L 22.85233879089355 1.999994277954102 L 9.147661209106445 1.999994277954102 M 8 -5.7220458984375e-06 L 24 -5.7220458984375e-06 L 32 13.68862438201904 L 24 27.37724494934082 L 8 27.37724494934082 L 0 13.68862438201904 L 8 -5.7220458984375e-06 Z" stroke="none" fill="#fff"/>
									</g>
								</svg>
							</div>
							<figure class="access-ranking__thumb">
								<?php if ( $thumb_url ) : ?>
									<img src="<?php echo $thumb_url; ?>" alt="<?php echo $title; ?>" loading="lazy" />
								<?php endif; ?>
							</figure>
							<div class="access-ranking-body">
								<h2 class="access-ranking-body__title">
									<?php echo $title; ?>
								</h2>
								<?php if ( $display_num ) : ?>
									<span class="access-ranking-body__views"><?php echo $view_num; ?> views</span>
								<?php endif; ?>
							</div>
						</article>
					</a>
				<?php endwhile; ?>
			</div>
		<?php else : ?>
			<p class="nmdb-no-entry"><?php _e( '記事、または投稿へのアクセスがまだありません。', NMDB_TEXT_DOMAIN ); ?></p>
		<?php endif; ?>
	</div>
<?php
	$content = ob_get_clean();

	wp_reset_postdata();

	return $content;
}

function nmdb_register_block_original_access_ranking()
{
	register_block_type('nmd-blocks/original-access-ranking', array(
		'editor_script'	=> 'nmd-blocks-editor-script',
		'editor_style'	=> 'nmd-blocks-editor-style',
		'script'		=> 'nmd-blocks-script',
		'style'			=> 'nmd-blocks-style',
		'attributes' 	=> array(
			'title' => array(
				'type'	=> 'string',
				'default' => __('人気記事', NMDB_TEXT_DOMAIN),
			),
			'num'	=> array(
				'type' => 'string',
			),
			'displayNum'	=> array(
				'type' => 'boolean',
			),
		),
		'render_callback'	=> 'nmdb_get_access_ranking',
	));
}
add_action('init', 'nmdb_register_block_original_access_ranking');
