<?php
/**
 * テキスト関連の関数
 */
if ( !defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * 改行を削除
 *
 * @param string $content 改行を削除したい文字列
 * @return string 改行を削除した文字列
 * @version 1.0.0
 */
if( !function_exists( 'nmdb_delete_breaks' ) ) {
	function nmdb_delete_breaks( $content ) {
		
		$content = str_replace( array( "\r\n", "\n", "\r" ), '', $content );
		$content = str_replace( PHP_EOL, '', $content );
		return $content;
	}
}

/**
 * 複数のスペースを削除
 *
 * @param string $content テキスト
 * @return string 複数のスペースを削除したテキスト
 * @version 1.0.0
 */
if( !function_exists( 'nmdb_trim_same_space' ) ) {
	function nmdb_trim_same_space( $content ){
		// 両サイドのスペースを消す
		$content  = trim( $content );
		// タブをスペースへ
		$content  = preg_replace('/[\t]/', '', $content );
		// 複数スペースを一つへ
		$content  = preg_replace('/\s(?=\s)/', '', $content );

		return $content;
	}
}

/**
 * 抜粋、descriptionなどを無害化
 *
 * @param string $content 抜粋、descriptionなど
 * @param boolean $do_shortcode ショートコードを実行するか
 * @return string 無害化されたテキスト
 * @version 1.0.0
 */
if( !function_exists( 'nmdb_sanitize_excerpt' ) ) {
	function nmdb_sanitize_excerpt( $content, $do_shortcode=true ) {
		
		if ( $do_shortcode ) $content = do_shortcode( $content );

		$content = strip_shortcodes( $content ); //展開できなかったショートコードは削除
		$content = strip_tags( $content );
		$content = nmdb_delete_breaks( $content );
		$content = nmdb_trim_same_space( $content );
		
		return $content;
	}
}

/**
 * 文字数を丸める
 *
 * @param string $text テキスト
 * @param int $length 最大文字列
 * @return string 丸めた後のテキスト
 * @version 1.0.0
 */
if( !function_exists( 'nmdb_mb_substr_text' ) ) {
	function nmdb_mb_substr_text( $text, $length = 100 ) {

		/**
		 * 最大文字数よりも長い場合は3点リーダーを付ける
		 */
		if( mb_strlen( $text, 'UTF-8' ) > $length ) {
			$text = mb_substr( $text, 0, $length, 'UTF-8' );
			return $text . '...';
		} else {
			return $text;
		}
	}
}

/**
 * コンマ区切りの文字列を配列にして返す
 *
 * @param string $str テキスト
 * @return array
 * @version 1.0.0
 */
if( !function_exists( 'nmdb_comma_separated_to_array' ) ) {
	function nmdb_comma_separated_to_array( $str ) {

		/**
		 * 全角などにも対応
		 */
		$str_list = str_replace( ['，', '、', '､'], ',', $str );
		$str_list = mb_convert_kana( $str_list, 'as' );
		$str_list = str_replace( array(" ", "　"), "", $str_list );
		$str_list = explode( ',', $str_list );

		return $str_list;
	}
}