<?php

if ( !defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * カスタマイザーの画像をサイズ指定して取得する
 *
 * @param string $name カスタマイザーのID
 * @param string $size 画像サイズ
 * @return string|false 画像URL
 * @version 1.0.0
 */
if( !function_exists( 'nmdb_get_the_customizer_image_url' ) ) {
    function nmdb_get_the_customizer_image_url( $name, $size = 'full' ){

        $image_mod = get_theme_mod( $name );

        if ( is_int( $image_mod ) ) { 
            $image_data = wp_get_attachment_image_src( $image_mod, '' );
            $image_url = $image_data[0] ?? false;
        } else {
            $image_url = esc_url( $image_mod );
        }

        if( empty( $image_url ) ) return;
        
        $image_id = attachment_url_to_postid( $image_url );

        $image_array = wp_get_attachment_image_src( $image_id, $size );
        
        $image_url = $image_array[0] ?? false;

        if ( $image_url ) {
            return $image_url;
        } else {
            return false;
        }
    }
}

/**
 * カスタマイザーの画像をサイズ指定して取得する
 *
 * @param string $name カスタマイザーのID
 * @param string $size 画像サイズ
 * @return array|false {
 *     @type string $0 Image source URL.
 *     @type int    $1 Image width in pixels.
 *     @type int    $2 Image height in pixels.
 *     @type bool   $3 Whether the image is a resized image.
 * }
 * @version 1.0.0
 */
if( !function_exists( 'nmdb_get_the_customizer_image_info' ) ) {
    function nmdb_get_the_customizer_image_info( $name, $size = 'full' ) {
        
        $image_mod = get_theme_mod( $name );
        $image_info_array = null;

        if ( is_int( $image_mod ) ) {
            // IDで取得する場合。

            /**
             * wp_get_attachment_image_srcの戻り値
             * [0] => url
             * [1] => width
             * [2] => height
             * [3] => 真偽値: リサイズされいている場合は true、元のサイズの場合は false
             */
            $image_info_array = wp_get_attachment_image_src( $image_mod, $size );
        } else {
            // URLで取得する場合
            $image_url = esc_url( $image_mod );
            $image_id = attachment_url_to_postid( $image_url );
            $image_info_array = wp_get_attachment_image_src( $image_id, $size );
        }

        if ( !empty($image_info_array) ) {
            return $image_info_array;
        } else {
            return false;
        }
    }
}

/**
 * サムネイル画像を取得する関数
 *
 * @param int $id 記事ID
 * @param string $size 画像サイズ
 * @return string 画像のURL
 * @version 1.0.0
 */
if( !function_exists( 'nmdb_get_thumbnail_url' ) ) {
    function nmdb_get_thumbnail_url( $id=null, $size="full" ) {

        if( !$id ) $id = get_the_ID();

        if( has_post_thumbnail( $id ) ) {

            $thumbnail_url = get_the_post_thumbnail_url( $id, $size );

        } elseif ( nmdb_get_the_customizer_image_url( 'nmdb_default_thumbnail', $size ) ) {

            $default_thumbnail_url = nmdb_get_the_customizer_image_url( 'nmdb_default_thumbnail', $size );
            $thumbnail_url = esc_url( $default_thumbnail_url );

        } else {
            switch ( $size ) {
                case 'full':
                $thumbnail_url = NMDB_PLUGIN_DIR_URL . '/dist/images/no-image/no-image.png';
                break;

                case 'large':
                $thumbnail_url = NMDB_PLUGIN_DIR_URL . '/dist/images/no-image/no-image_large.png';
                break;

                case 'medium_large':
                $thumbnail_url = NMDB_PLUGIN_DIR_URL . '/dist/images/no-image/no-image_medium-large.png';
                break;

                case 'medium':
                $thumbnail_url = NMDB_PLUGIN_DIR_URL . '/dist/images/no-image/no-image_medium.png';
                break;

                case 'thumbnail':
                $thumbnail_url = NMDB_PLUGIN_DIR_URL . '/dist/images/no-image/no-image_thumbnail.png';
                break;

                default:
                $thumbnail_url = NMDB_PLUGIN_DIR_URL . '/dist/images/no-image/no-image.png';
                break;
            }
        }
        return $thumbnail_url;
    }
}


/**
 * CSSなどのファイルの中身を文字列で返す
 * @param string ファイルのパス
 * @return string
 * @version 1.0.0
 */
if( !function_exists( 'nmdb_get_file_contents' ) ) {
    function nmdb_get_file_contents( $path ) {
        ob_start();
        include get_template_directory() . $path;
        $contents = ob_get_contents();
        ob_end_clean();

        return $contents;
    }
}


/**
 * クローラーのアクセス判別
 * @return bool
 * @version 1.0.0
 */
if( ! function_exists( 'nmdb_is_bot' ) ) {
    function nmdb_is_bot() {
        $ua = $_SERVER['HTTP_USER_AGENT'];
    
        $bots = array(
            "googlebot",
            "msnbot",
            "yahoo"
        );

        foreach( $bots as $bot ) {
            if (stripos( $ua, $bot ) !== false){
                return true;
            }
        }
        return false;
    }
}

/**
 * HEXをRGBに変換
 * @param string $hex カラーコード
 * @return array
 * @version 1.0.0
 */
if( ! function_exists( 'nmdb_hex2rgb' ) ) {
    function nmdb_hex2rgb ( $hex ) {
        if ( substr( $hex, 0, 1 ) == "#" ) $hex = substr( $hex, 1 ) ;
        if ( strlen( $hex ) == 3 ) $hex = substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) . substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) . substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) ;
        return array_map( "hexdec", [ substr( $hex, 0, 2 ), substr( $hex, 2, 2 ), substr( $hex, 4, 2 ) ] ) ;
    }
}
