<?php
/**
 * 抜粋関連の関数
 */
if ( !defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * ショートコード展開後の抜粋を取得
 *
 * @param int $length 最大文字数
 * @param int $post_id 記事ID
 * @param bool $do_shortcode ショートコードを展開するか
 * @return string 記事の抜粋
 * @version 1.0.0
 */
if( !function_exists( 'nmdb_get_excerpt' ) ) {
    function nmdb_get_excerpt( $length=140, $post_id=null, $do_shortcode=true ) {
        if ( $post_id ) {
            $post = get_post( $post_id );
        } else {
            global $post;
        }
        
        $suffix = '...';
        $content = $post->post_content;
        $content = nmdb_sanitize_excerpt( $content, $do_shortcode );
        $content = mb_substr( $content,0, $length );
        $content .= $suffix;
        
        return $content;
    }
}

/**
 * ループ外から抜粋を取得する関数
 *
 * @param int $post_id 記事ID
 * @param int $length 最大文字数
 * @param bool $do_shortcode ショートコードを展開するか
 * @return string 記事の抜粋
 * @version 1.0.0
 */
if( !function_exists( 'nmdb_get_the_excerpt_outside' ) ) {
    function nmdb_get_the_excerpt_outside( $post_id, $length=null ){
        global $post;
        $post_backup = $post;
        $post = get_post( $post_id );
        $output = get_the_excerpt();
        $output = str_replace( '[toc]', '', $output );
        if( $length ) $output = mb_substr( $output, 0, $length );
        $post = $post_backup;
        return $output;
    }
}